/////////////////////////////////////////////////////////////////////////////////

// Original obtained from GlsSandbox.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define time u_Elapsed
#define resolution u_WindowSize
#define mouse AUTO_MOUSE
#define surfacePosition vec2(2.0*gl_FragCoord.xy/resolution-1.0)

/////////////////////////////////////////////////////////////////////////////////

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.1,0.177777)*0.1
#define AUTO_MOUSE  vec2((1.0+cos(time*MOUSE_SPEED))/2.0)

/////////////////////////////////////////////////////////////////////////////////

// precision mediump float;

// uniform float time;      // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 resolution; // Replaced for VGHD by defines above. TheEmu.
// uniform vec2 mouse;      // Replaced for VGHD by defines above. TheEmu.
// varying vec2 surfacePosition; // Not used in the original. TheEmu.
#define ITERATIONS 40

void main( void ) {
	
	vec3 color = vec3(0.0,0.0,0.0);
	vec2 p_pos = ( gl_FragCoord.xy / resolution.xy ) * 2.0 - 1.0;
	p_pos.x *= (resolution.x / resolution.y);
	int n = 10;
	vec3 light_color = vec3(0.8, 0.5, 0.1); // RGB, proportional values, higher increases intensity
	
	for(int i = 0; i < ITERATIONS; i++){
		float phase = mouse.x * 180.0 * float(i)/float(ITERATIONS);
		vec2 pos = vec2(sin(time + phase), float(i)/float(ITERATIONS) * 2.0 - 1.0);
		
		vec2 diff = abs(pos - p_pos);
		float dist = diff.x * diff.x + diff.y * diff.y;
		float c = 0.0005/dist;
	
		color += vec3(c * light_color);
		
	
	}
		
	gl_FragColor = vec4(color, length(color) );

}